-- 
-- @author	TwistedGA
-- @date	18/09/2022
--
-- Portions of this script was authored by Giants and modified by the above. 
-- Very few changes were made to the original functions and conditions
-- have been set based on the desired output. Modify at your own risk.
--

relightStandalone = {}
relightStandalone.modDir = g_currentModDirectory
relightStandalone.xmlFilename = Utils.getFilename('data/relightStandalone.xml', relightStandalone.modDir)

function relightStandalone:loadEnvironment(xmlFile)
	--local filename = Utils.getFilename(getXMLString(xmlFile, 'map.environment#filename'), self.baseDirectory) --Disable default environment fetch.
	self.environment = Environment.new(self)
	--self.environment:load(filename) --Disable default environment loading.
	self.environment:load(relightStandalone.xmlFilename)
	if self.missionInfo.environmentXMLLoad ~= nil and self:getIsServer() then
		local envXmlFile = loadXMLFile('environmentXML', self.missionInfo.environmentXMLLoad)
		self.environment:loadFromXMLFile(envXmlFile, 'environment')
		delete(envXmlFile)
	end
	self.hud:setEnvironment(self.environment)
	self.inGameMenu:setEnvironment(self.environment)
end
Mission00.loadEnvironment = Utils.overwrittenFunction(Mission00.loadEnvironment, relightStandalone.loadEnvironment)

--Override default !mapDir! to load envMap and colorGradings from !modDir! instead.
function relightStandalone:load(xmlFile, baseKey)
	local envMap = xmlFile:getString(baseKey .. ".envMap#basePath")
	local day = xmlFile:getString(baseKey .. ".colorGrading.day#filename")
	local night = xmlFile:getString(baseKey .. ".colorGrading.night#filename")
	self.envMapBasePath = Utils.getFilename(envMap, relightStandalone.modDir)
	self.colorGradingDay = Utils.getFilename(day, relightStandalone.modDir)
	self.colorGradingNight = Utils.getFilename(night, relightStandalone.modDir)
end
Lighting.load = Utils.appendedFunction(Lighting.load, relightStandalone.load)