extendInputHUD = {}

function extendInputHUD:loadMap()
    InputHelpDisplay.getMaxEntryCount = Utils.overwrittenFunction(InputHelpDisplay.getMaxEntryCount,extendInputHUD.getMaxEntryCount)
end

function extendInputHUD.registerEventListeners(vehicleType)    
    SpecializationUtil.registerEventListener(vehicleType, "loadMap", extendInputHUD)
    SpecializationUtil.registerEventListener(vehicleType, "getMaxEntryCount", extendInputHUD)
end

function extendInputHUD:getMaxEntryCount(prio, ignoreLive)
	local extendInputHUDcount = 1

	if g_gameSettings.uiScale < 1.26 and g_gameSettings.uiScale > 1.15 then
		extendInputHUDcount = 3
	elseif g_gameSettings.uiScale <= 1.15 and g_gameSettings.uiScale > 1.05 then
		extendInputHUDcount = 5
	elseif g_gameSettings.uiScale <= 1.05 and g_gameSettings.uiScale > 0.95 then
		extendInputHUDcount = 6
	elseif g_gameSettings.uiScale <= 0.95 and g_gameSettings.uiScale > 0.90 then
		extendInputHUDcount = 7
	elseif g_gameSettings.uiScale <= 0.90 and g_gameSettings.uiScale > 0.85 then
		extendInputHUDcount = 8
	elseif g_gameSettings.uiScale <= 0.85 and g_gameSettings.uiScale > 0.75 then
		extendInputHUDcount = 9
	elseif g_gameSettings.uiScale <= 0.75 and g_gameSettings.uiScale > 0.65 then
		extendInputHUDcount = 10
	elseif g_gameSettings.uiScale <= 0.65 and g_gameSettings.uiScale > 0.55 then
		extendInputHUDcount = 10
	elseif g_gameSettings.uiScale <= 0.55 then
		extendInputHUDcount = 10
	end


	prio = Utils.getNoNil(prio, false)
    local count = ((prio and InputHelpDisplay.ENTRY_COUNT_PC) or InputHelpDisplay.ENTRY_COUNT_PRIO_PC) + extendInputHUDcount
    if self.isConsoleVersion then
        count = ((prio and InputHelpDisplay.ENTRY_COUNT_CONSOLE) or InputHelpDisplay.ENTRY_COUNT_PRIO_CONSOLE) + extendInputHUDcount + 4
    end
    if not ignoreLive then
        -- Combos also take space
        if self.hasComboCommands then
            count = count - 1
        end
        count = count - #self.extraHelpTexts
    end
    for _, hudExtension in pairs(self.vehicleHudExtensions) do
        if hudExtension.getHelpEntryCountReduction ~= nil then
            count = count - hudExtension:getHelpEntryCountReduction()
        end
    end
    return count - 4
end

addModEventListener(extendInputHUD)
