Contracts = {}

Contracts.modDirectory = g_currentModDirectory

function Contracts:init()

    MissionManager.initDataStructures = Utils.appendedFunction(MissionManager.initDataStructures, Contracts.initDataStructures)
    MissionManager.loadMapData = Utils.appendedFunction(MissionManager.loadMapData, Contracts.initDataStructures)
    InGameMenuContractsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuContractsFrame.onFrameOpen, Contracts.onFrameOpen)
    InGameMenuContractsFrame.onFrameClose = Utils.appendedFunction(InGameMenuContractsFrame.onFrameClose, Contracts.onFrameClose)

    --Settings
    InGameMenuGameSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGameSettingsFrame.onFrameOpen, Contracts.onFrameOpenSettings)

    --MissionVehicles
    MissionManager.loadMissionVehicles = Utils.overwrittenFunction(MissionManager.loadMissionVehicles, Contracts.loadMissionVehicles)
end

function Contracts:onFrameOpen()

    if g_currentMission.inGameMenu.newContractsButton == nil then
        g_currentMission.inGameMenu.newContractsButton = g_currentMission.inGameMenu.menuButton[1]:clone(self)
        g_currentMission.inGameMenu.newContractsButton.onClickCallback = Contracts.onClickNewCallback
        g_currentMission.inGameMenu.newContractsButton:setText(g_i18n:getText("new_contracts"))
        g_currentMission.inGameMenu.newContractsButton:setInputAction("MENU_EXTRA_1")
        g_currentMission.inGameMenu.menuButton[1].parent:addElement(g_currentMission.inGameMenu.newContractsButton)

    end

    if g_currentMission.inGameMenu.clearContractsButton == nil then
        g_currentMission.inGameMenu.clearContractsButton = g_currentMission.inGameMenu.menuButton[1]:clone(self)
        g_currentMission.inGameMenu.clearContractsButton.onClickCallback = Contracts.onClickClearCallback
        g_currentMission.inGameMenu.clearContractsButton:setText(g_i18n:getText("clear_contracts"))
        g_currentMission.inGameMenu.clearContractsButton:setInputAction("MENU_EXTRA_2")
        g_currentMission.inGameMenu.menuButton[1].parent:addElement(g_currentMission.inGameMenu.clearContractsButton)
    end
end

function Contracts:onFrameClose()
    -- remove new buttons
    if g_currentMission.inGameMenu.newContractsButton ~= nil then
        g_currentMission.inGameMenu.newContractsButton:unlinkElement()
        g_currentMission.inGameMenu.newContractsButton:delete()
        g_currentMission.inGameMenu.newContractsButton = nil
    end

    if g_currentMission.inGameMenu.clearContractsButton ~= nil then
        g_currentMission.inGameMenu.clearContractsButton:unlinkElement()
        g_currentMission.inGameMenu.clearContractsButton:delete()
        g_currentMission.inGameMenu.clearContractsButton = nil
    end
end


function Contracts:onClickNewCallback()
    g_client:getServerConnection():sendEvent(CreateContractsEvent:new())
end

function Contracts:initDataStructures()
    MissionManager.MAX_MISSIONS = 1000
    MissionManager.ACTIVE_CONTRACT_LIMIT = 250
    MissionManager.MAX_MISSIONS_PER_GENERATION = 200 --4
    MissionManager.MAX_TRIES_PER_GENERATION = 100 --5
end


function Contracts:onClickClearCallback()
    g_client:getServerConnection():sendEvent(ClearContractsEvent:new())
end


function Contracts.loadMissionVehicles(superSelf, superFunc, path)
    local path2 = Utils.getFilename("missionVehicles.xml", Contracts.modDirectory)
    if path2 ~= nil then
        return superFunc(superSelf, path2)
    end
end

function Contracts:onFrameOpenSettings(self)

end


Contracts:init();