---
--- Created by Ragman2414.
--- DateTime: 15.12.2021 13:28
---


ClearContractsEvent= {}
ClearContractsEvent_mt = Class(ClearContractsEvent, Event)
InitEventClass(ClearContractsEvent, "ClearContractsEvent")

---Create instance of Event class
-- @return table self instance of class event
function ClearContractsEvent.emptyNew()
    local self = Event.new(ClearContractsEvent_mt)
    return self
end


---Create new instance of event
-- @param table object object
-- @param boolean isBlocked is blocked
function ClearContractsEvent.new()
    local self = ClearContractsEvent.emptyNew()
    return self
end


---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ClearContractsEvent:readStream(streamId, connection)
    self:run(connection)
end


---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ClearContractsEvent:writeStream(streamId, connection)

end


---Run action on receiving side
-- @param integer connection connection
function ClearContractsEvent:run(connection)
    if g_server ~= nil and connection:getIsServer() == false then
        g_server:broadcastEvent(self, true)
    else
        for key,mission in pairs(g_missionManager.missions) do
            if(mission.status == 0) then
                g_missionManager.deleteMission(g_missionManager, mission)
            end
        end
        if g_currentMission.inGameMenu ~=nil and g_currentMission.inGameMenu.pageContracts ~=nil then
            g_currentMission.inGameMenu.pageContracts:updateList()
        end
    end

end


