-- Name: BSU_bunkerSiloUtilities
-- Author: Chissel

BSU_bunkerSiloUtilities = {}

function BSU_bunkerSiloUtilities.interactionTriggerCallback(bunkerSilo, onEnter, onLeave)
    if onLeave then
        BSU_bunkerSiloUtilities.unregisterCloseCoverActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterClearAreaActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterReopenCoverActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterChangeCoverActionEvent(bunkerSilo)
    end
end

function BSU_bunkerSiloUtilities.getIsActivatable(bunkerSilo)
    local ix, iy, iz = bunkerSilo:getInteractionPosition()

    if ix == nil then
        BSU_bunkerSiloUtilities.unregisterCloseCoverActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterClearAreaActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterReopenCoverActionEvent(bunkerSilo)
        BSU_bunkerSiloUtilities.unregisterChangeCoverActionEvent(bunkerSilo)
        return
    end

    local closerToFront = bunkerSilo:getIsCloserToFront(ix, iy, iz)

    BSU_bunkerSiloUtilities.registerChangeCoverActionEvent(bunkerSilo)

    if closerToFront then
        if bunkerSilo.isOpenedAtFront then
            BSU_bunkerSiloUtilities.registerCloseCoverActionEvent(bunkerSilo)
        else
            BSU_bunkerSiloUtilities.unregisterCloseCoverActionEvent(bunkerSilo)
        end
    end

    if not closerToFront then
        if bunkerSilo.isOpenedAtBack then
            BSU_bunkerSiloUtilities.registerCloseCoverActionEvent(bunkerSilo)
        else
            BSU_bunkerSiloUtilities.unregisterCloseCoverActionEvent(bunkerSilo)
        end
    end

    if bunkerSilo.fillLevel == 0 then
        BSU_bunkerSiloUtilities.unregisterClearAreaActionEvent(bunkerSilo)
    else
        BSU_bunkerSiloUtilities.registerClearAreaActionEventIfNeeded(bunkerSilo)
    end

    if bunkerSilo.state == BunkerSilo.STATE_CLOSED then
        BSU_bunkerSiloUtilities.registerReopenCoverActionEvent(bunkerSilo)
    else
        BSU_bunkerSiloUtilities.unregisterReopenCoverActionEvent(bunkerSilo)
    end
end

-- Clear area

function BSU_bunkerSiloUtilities.registerClearAreaActionEventIfNeeded(bunkerSilo)
    if bunkerSilo.isClient and bunkerSilo.bsu_clearAreaEventId == nil and bunkerSilo.fillLevel > 0 then
        local _, clearAreaEventId = g_inputBinding:registerActionEvent(InputAction.BSU_CLEAR_AREA, bunkerSilo, bunkerSilo.openClearAreaDialog, false, true, false, true)

        if clearAreaEventId == nil then
            return
        end

        g_inputBinding:setActionEventTextVisibility(clearAreaEventId, true)
        bunkerSilo.bsu_clearAreaEventId = clearAreaEventId
    end
end

function BSU_bunkerSiloUtilities.unregisterClearAreaActionEvent(bunkerSilo)
    if bunkerSilo.bsu_clearAreaEventId ~= nil then
        g_inputBinding:removeActionEvent(bunkerSilo.bsu_clearAreaEventId)
        bunkerSilo.bsu_clearAreaEventId = nil
    end
end

-- Close cover

function BSU_bunkerSiloUtilities.registerCloseCoverActionEvent(bunkerSilo)
    if bunkerSilo.isClient and bunkerSilo.bsu_closeCoverEventId == nil then
        local _, closeCoverEventId = g_inputBinding:registerActionEvent(InputAction.BSU_CLOSE_COVER, bunkerSilo, bunkerSilo.closeCoverCallback, false, true, false, true)

        if closeCoverEventId == nil then
            return
        end

        g_inputBinding:setActionEventTextVisibility(closeCoverEventId, true)
        bunkerSilo.bsu_closeCoverEventId = closeCoverEventId
    end
end

function BSU_bunkerSiloUtilities.unregisterCloseCoverActionEvent(bunkerSilo)
    if bunkerSilo.bsu_closeCoverEventId ~= nil then
        g_inputBinding:removeActionEvent(bunkerSilo.bsu_closeCoverEventId)
        bunkerSilo.bsu_closeCoverEventId = nil
    end
end

-- Reopen

function BSU_bunkerSiloUtilities.registerReopenCoverActionEvent(bunkerSilo)
    if bunkerSilo.isClient and bunkerSilo.bsu_reopenCoverEventId == nil then
        local _, reopenCoverEventId = g_inputBinding:registerActionEvent(InputAction.BSU_REOPEN_COVER, bunkerSilo, bunkerSilo.openReopenCoverDialog, false, true, false, true)

        if reopenCoverEventId == nil then
            return
        end

        g_inputBinding:setActionEventTextVisibility(reopenCoverEventId, true)
        bunkerSilo.bsu_reopenCoverEventId = reopenCoverEventId
    end
end

function BSU_bunkerSiloUtilities.unregisterReopenCoverActionEvent(bunkerSilo)
    if bunkerSilo.bsu_reopenCoverEventId ~= nil then
        g_inputBinding:removeActionEvent(bunkerSilo.bsu_reopenCoverEventId)
        bunkerSilo.bsu_reopenCoverEventId = nil
    end
end

-- Change cover

function BSU_bunkerSiloUtilities.registerChangeCoverActionEvent(bunkerSilo)
    if bunkerSilo.isClient and bunkerSilo.bsu_changeCoverEventId == nil then
        local _, changeCoverEventId = g_inputBinding:registerActionEvent(InputAction.BSU_CHANGE_COVER, bunkerSilo, bunkerSilo.changeCoverCallback, false, true, false, true)

        if changeCoverEventId == nil then
            return
        end

        g_inputBinding:setActionEventTextVisibility(changeCoverEventId, true)
        bunkerSilo.bsu_changeCoverEventId = changeCoverEventId
    end
end

function BSU_bunkerSiloUtilities.unregisterChangeCoverActionEvent(bunkerSilo)
    if bunkerSilo.bsu_changeCoverEventId ~= nil then
        g_inputBinding:removeActionEvent(bunkerSilo.bsu_changeCoverEventId)
        bunkerSilo.bsu_changeCoverEventId = nil
    end
end