-- Name: BSU_bunkerSiloExtension
-- Author: Chissel

BSU_bunkerSiloExtension = {}

function BSU_bunkerSiloExtension:registerSavegameXMLPaths(basePath)
    local path = basePath.."#bsu_tarp_type"
    self:register(XMLValueType.STRING, path, "Current tarp fill type", FillType.TARP)
end


function BSU_bunkerSiloExtension:saveToXMLFile(xmlFile, key, usedModNames)
    local path = key.."#bsu_tarp_type"
    local fermentingFillType = self.fermentingFillType or FillType.TARP
    local fillType = g_fillTypeManager:getFillTypeByIndex(fermentingFillType)
    xmlFile:setValue(path, fillType.name)
end

function BSU_bunkerSiloExtension:loadFromXMLFile(xmlFile, key)
    local path = key.."#bsu_tarp_type"
    local tarpType = xmlFile:getValue(path, false) or "TARP"
    local fillType = g_fillTypeManager:getFillTypeByName(tarpType)
    self.fermentingFillType = fillType.index
end

function BSU_bunkerSiloExtension:readStream(streamId, connection)
    self.fermentingFillType = streamReadUInt16(streamId)
end

function BSU_bunkerSiloExtension:writeStream(streamId, connection)
    local fermentingFillType = self.fermentingFillType or FillType.TARP
    streamWriteUInt16(streamId, fermentingFillType)
end
