-- Name: BSU_addHeightTypes
-- Author: Chissel

BSU_addHeightTypes = {}

local modName = g_currentModName
local modDirectory = g_currentModDirectory


function BSU_addHeightTypes:loadMapData(xmlFile, missionInfo, baseDirectory)
    local heightTypesXML = loadXMLFile("BSU_heightTypes", modDirectory.."xml/BSU_heightTypes.xml")
    g_densityMapHeightManager:loadDensityMapHeightTypes(heightTypesXML, missionInfo, modDirectory, false)

    BSU_bunkerSiloOverwrites.availableFillTypes = BSU_addHeightTypes.getAllTrapTypes(g_densityMapHeightManager.heightTypes) --{FillType.TARP, FillType.TARP_GREEN, FillType.TARP_LIGHT_GREEN, FillType.TARP_BLACK}
end

function BSU_addHeightTypes.getAllTrapTypes(heightTypes)
    local allTarpFillTypes = {}

    for k, heightType in ipairs(heightTypes) do
        if string.find(heightType.fillTypeName, "TARP") then
            table.insert(allTarpFillTypes, heightType.fillTypeIndex)
        end
    end

    return allTarpFillTypes
end